/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.lang.reflect.Type;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.data.SlotMatcher;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class NodeStatus {
    private final NodeId nodeId;
    private final URI externalUri;
    private final int maxSessionCount;
    private final Set<Slot> slots;
    private final Availability availability;
    private final Duration heartbeatPeriod;
    private final Duration sessionTimeout;
    private final String version;
    private final Map<String, String> osInfo;

    public NodeStatus(NodeId nodeId, URI externalUri, int maxSessionCount, Set<Slot> slots, Availability availability, Duration heartbeatPeriod, Duration sessionTimeout, String version, Map<String, String> osInfo) {
        this.nodeId = Require.nonNull("Node id", nodeId);
        this.externalUri = Require.nonNull("URI", externalUri);
        this.maxSessionCount = Require.positive("Max session count", maxSessionCount, "Make sure that a driver is available on $PATH");
        this.slots = Collections.unmodifiableSet(new HashSet(Require.nonNull("Slots", slots)));
        this.availability = Require.nonNull("Availability", availability);
        this.heartbeatPeriod = heartbeatPeriod;
        this.sessionTimeout = sessionTimeout;
        this.version = Require.nonNull("Grid Node version", version);
        this.osInfo = Require.nonNull("Node host OS info", osInfo);
    }

    public static NodeStatus fromJson(JsonInput input) {
        NodeId nodeId = null;
        URI externalUri = null;
        int maxSessions = 0;
        Set slots = null;
        Availability availability = null;
        Duration heartbeatPeriod = null;
        Duration sessionTimeout = null;
        String version = null;
        Map osInfo = null;
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "availability": {
                    availability = (Availability)((Object)input.read((Type)((Object)Availability.class)));
                    continue block22;
                }
                case "heartbeatPeriod": {
                    heartbeatPeriod = Duration.ofMillis((Long)input.read((Type)((Object)Long.class)));
                    continue block22;
                }
                case "sessionTimeout": {
                    sessionTimeout = Duration.ofMillis((Long)input.read((Type)((Object)Long.class)));
                    continue block22;
                }
                case "nodeId": {
                    nodeId = (NodeId)input.read((Type)((Object)NodeId.class));
                    continue block22;
                }
                case "maxSessions": {
                    maxSessions = (Integer)input.read((Type)((Object)Integer.class));
                    continue block22;
                }
                case "slots": {
                    slots = (Set)input.read(new TypeToken<Set<Slot>>(){}.getType());
                    continue block22;
                }
                case "externalUri": {
                    externalUri = (URI)input.read((Type)((Object)URI.class));
                    continue block22;
                }
                case "version": {
                    version = (String)input.read((Type)((Object)String.class));
                    continue block22;
                }
                case "osInfo": {
                    osInfo = (Map)input.read((Type)((Object)Map.class));
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new NodeStatus(nodeId, externalUri, maxSessions, slots, availability, heartbeatPeriod, sessionTimeout, version, osInfo);
    }

    public boolean hasCapability(Capabilities caps, SlotMatcher slotMatcher) {
        return this.slots.stream().anyMatch(slot -> slot.isSupporting(caps, slotMatcher));
    }

    public boolean hasCapacity() {
        return this.slots.stream().filter(slot -> slot.getSession() != null).count() < (long)this.maxSessionCount;
    }

    public boolean hasCapacity(Capabilities caps, SlotMatcher slotMatcher) {
        return this.slots.stream().filter(slot -> slot.getSession() != null).count() < (long)this.maxSessionCount && this.slots.stream().anyMatch(slot -> slot.getSession() == null && slot.isSupporting(caps, slotMatcher));
    }

    public int getMaxSessionCount() {
        return this.maxSessionCount;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public URI getExternalUri() {
        return this.externalUri;
    }

    public Set<Slot> getSlots() {
        return this.slots;
    }

    public Availability getAvailability() {
        return this.availability;
    }

    public Duration getHeartbeatPeriod() {
        return this.heartbeatPeriod;
    }

    public Duration getSessionTimeout() {
        return this.sessionTimeout;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getOsInfo() {
        return this.osInfo;
    }

    public float getLoad() {
        float inUse = this.slots.parallelStream().filter(slot -> slot.getSession() != null).count();
        return inUse / (float)this.maxSessionCount * 100.0f;
    }

    public long getLastSessionCreated() {
        return this.slots.parallelStream().map(Slot::getLastStarted).mapToLong(Instant::toEpochMilli).max().orElse(0L);
    }

    public boolean equals(Object o) {
        if (!(o instanceof NodeStatus)) {
            return false;
        }
        NodeStatus that = (NodeStatus)o;
        return Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.externalUri, that.externalUri) && this.maxSessionCount == that.maxSessionCount && Objects.equals(this.slots, that.slots) && Objects.equals((Object)this.availability, (Object)that.availability) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.externalUri, this.maxSessionCount, this.slots, this.version);
    }

    private Map<String, Object> toJson() {
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        toReturn.put("nodeId", this.nodeId);
        toReturn.put("externalUri", this.externalUri);
        toReturn.put("maxSessions", this.maxSessionCount);
        toReturn.put("slots", this.slots);
        toReturn.put("availability", (Object)this.availability);
        toReturn.put("heartbeatPeriod", this.heartbeatPeriod.toMillis());
        toReturn.put("sessionTimeout", this.sessionTimeout.toMillis());
        toReturn.put("version", this.version);
        toReturn.put("osInfo", this.osInfo);
        return Collections.unmodifiableMap(toReturn);
    }
}

