/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.node.CustomLocatorHandler;
import org.openqa.selenium.grid.node.DownloadFile;
import org.openqa.selenium.grid.node.Drain;
import org.openqa.selenium.grid.node.ForwardWebDriverCommand;
import org.openqa.selenium.grid.node.GetNodeSession;
import org.openqa.selenium.grid.node.HealthCheck;
import org.openqa.selenium.grid.node.IsSessionOwner;
import org.openqa.selenium.grid.node.NewNodeSession;
import org.openqa.selenium.grid.node.StatusHandler;
import org.openqa.selenium.grid.node.StopNodeSession;
import org.openqa.selenium.grid.node.UploadFile;
import org.openqa.selenium.grid.security.RequiresSecretFilter;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.locators.CustomLocator;
import org.openqa.selenium.remote.tracing.SpanDecorator;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.status.HasReadyState;

public abstract class Node
implements HasReadyState,
Routable {
    private static final Logger LOG = Logger.getLogger(Node.class.getName());
    private static final BuildInfo INFO = new BuildInfo();
    private static final ImmutableMap<String, String> OS_INFO = Node.loadOsInfo();
    protected final Tracer tracer;
    private final NodeId id;
    private final URI uri;
    private final Duration sessionTimeout;
    private final Route routes;
    protected boolean draining;

    protected Node(Tracer tracer, NodeId id, URI uri, Secret registrationSecret, Duration sessionTimeout) {
        this.tracer = Require.nonNull("Tracer", tracer);
        this.id = Require.nonNull("Node id", id);
        this.uri = Require.nonNull("URI", uri);
        this.sessionTimeout = Require.positive("Session timeout", sessionTimeout);
        Require.nonNull("Registration secret", registrationSecret);
        RequiresSecretFilter requiresSecret = new RequiresSecretFilter(registrationSecret);
        Set<CustomLocator> customLocators = StreamSupport.stream(ServiceLoader.load(CustomLocator.class).spliterator(), false).collect(Collectors.toSet());
        if (!customLocators.isEmpty()) {
            String names = customLocators.stream().map(CustomLocator::getLocatorName).collect(Collectors.joining(", "));
            LOG.info("Binding additional locator mechanisms: " + names);
        }
        Json json = new Json();
        this.routes = Route.combine((Routable)Route.matching(req -> HttpSessionId.getSessionId(req.getUri()).map(SessionId::new).map(this::isSessionOwner).orElse(false)).to(() -> new ForwardWebDriverCommand(this)).with(this.spanDecorator("node.forward_command")), new Routable[]{new CustomLocatorHandler(this, registrationSecret, customLocators), Route.post("/session/{sessionId}/se/file").to(params -> new UploadFile(this, this.sessionIdFrom((Map<String, String>)params))).with(this.spanDecorator("node.upload_file")), Route.get("/session/{sessionId}/se/files").to(params -> new DownloadFile(this, this.sessionIdFrom((Map<String, String>)params))).with(this.spanDecorator("node.download_file")), Route.post("/session/{sessionId}/se/files").to(params -> new DownloadFile(this, this.sessionIdFrom((Map<String, String>)params))).with(this.spanDecorator("node.download_file")), Route.delete("/session/{sessionId}/se/files").to(params -> new DownloadFile(this, this.sessionIdFrom((Map<String, String>)params))).with(this.spanDecorator("node.download_file")), Route.get("/se/grid/node/owner/{sessionId}").to(params -> new IsSessionOwner(this, this.sessionIdFrom((Map<String, String>)params))).with(this.spanDecorator("node.is_session_owner").andThen(requiresSecret)), Route.delete("/se/grid/node/session/{sessionId}").to(params -> new StopNodeSession(this, this.sessionIdFrom((Map<String, String>)params))).with(this.spanDecorator("node.stop_session").andThen(requiresSecret)), Route.get("/se/grid/node/session/{sessionId}").to(params -> new GetNodeSession(this, this.sessionIdFrom((Map<String, String>)params))).with(this.spanDecorator("node.get_session").andThen(requiresSecret)), Route.post("/se/grid/node/session").to(() -> new NewNodeSession(this, json)).with(this.spanDecorator("node.new_session").andThen(requiresSecret)), Route.post("/se/grid/node/drain").to(() -> new Drain(this, json)).with(this.spanDecorator("node.drain").andThen(requiresSecret)), Route.get("/se/grid/node/status").to(() -> req -> (HttpResponse)new HttpResponse().setContent(Contents.asJson(this.getStatus()))).with(this.spanDecorator("node.node_status")), Route.get("/status").to(() -> new StatusHandler(this)).with(this.spanDecorator("node.status"))});
    }

    private static ImmutableMap<String, String> loadOsInfo() {
        return ImmutableMap.of("arch", System.getProperty("os.arch"), "name", System.getProperty("os.name"), "version", System.getProperty("os.version"));
    }

    private SessionId sessionIdFrom(Map<String, String> params) {
        return new SessionId(params.get("sessionId"));
    }

    private SpanDecorator spanDecorator(String name) {
        return new SpanDecorator(this.tracer, req -> name);
    }

    public NodeId getId() {
        return this.id;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getNodeVersion() {
        return String.format("%s (revision %s)", INFO.getReleaseLabel(), INFO.getBuildRevision());
    }

    public ImmutableMap<String, String> getOsInfo() {
        return OS_INFO;
    }

    public abstract Either<WebDriverException, CreateSessionResponse> newSession(CreateSessionRequest var1);

    public abstract HttpResponse executeWebDriverCommand(HttpRequest var1);

    public abstract Session getSession(SessionId var1) throws NoSuchSessionException;

    public TemporaryFilesystem getUploadsFilesystem(SessionId id) throws IOException {
        throw new UnsupportedOperationException();
    }

    public TemporaryFilesystem getDownloadsFilesystem(UUID uuid) throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract HttpResponse uploadFile(HttpRequest var1, SessionId var2);

    public abstract HttpResponse downloadFile(HttpRequest var1, SessionId var2);

    public abstract void stop(SessionId var1) throws NoSuchSessionException;

    public abstract boolean isSessionOwner(SessionId var1);

    public abstract boolean isSupporting(Capabilities var1);

    public abstract NodeStatus getStatus();

    public abstract HealthCheck getHealthCheck();

    public Duration getSessionTimeout() {
        return this.sessionTimeout;
    }

    public boolean isDraining() {
        return this.draining;
    }

    public abstract void drain();

    @Override
    public boolean matches(HttpRequest req) {
        return this.routes.matches(req);
    }

    @Override
    public HttpResponse execute(HttpRequest req) {
        return this.routes.execute(req);
    }
}

