/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.relay;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.grid.node.relay.RelaySessionFactory;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.Tracer;

public class RelayOptions {
    static final String RELAY_SECTION = "relay";
    private static final Logger LOG = Logger.getLogger(RelayOptions.class.getName());
    private static final Json JSON = new Json();
    private final Config config;

    public RelayOptions(Config config) {
        this.config = Require.nonNull("Config", config);
    }

    public URI getServiceUri() {
        try {
            Optional<String> possibleUri = this.config.get(RELAY_SECTION, "url");
            if (possibleUri.isPresent()) {
                return new URI(possibleUri.get());
            }
            Optional<String> possibleHost = this.config.get(RELAY_SECTION, "host");
            Optional<Integer> possiblePort = this.config.getInt(RELAY_SECTION, "port");
            if (possibleHost.isPresent() && possiblePort.isPresent()) {
                String host = possibleHost.get();
                int port = possiblePort.get();
                host = !host.startsWith("http") ? String.format("http://%s:%s", host, port) : String.format("%s:%s", host, port);
                URI uri = new URI(host);
                return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, null);
            }
            throw new ConfigException("Unable to determine the service url", new Object[0]);
        }
        catch (URISyntaxException e) {
            throw new ConfigException("Unable to determine the service url", new Object[]{e});
        }
    }

    public URI getServiceStatusUri() {
        try {
            if (!this.config.get(RELAY_SECTION, "status-endpoint").isPresent()) {
                return null;
            }
            Object statusEndpoint = this.config.get(RELAY_SECTION, "status-endpoint").orElse("/status");
            if (!((String)statusEndpoint).startsWith("/")) {
                statusEndpoint = "/" + (String)statusEndpoint;
            }
            URI serviceUri = this.getServiceUri();
            return new URI(serviceUri.toString() + (String)statusEndpoint);
        }
        catch (URISyntaxException e) {
            throw new ConfigException("Unable to determine the service status url", new Object[]{e});
        }
    }

    public String getServiceProtocolVersion() {
        String rawProtocolVersion = this.config.get(RELAY_SECTION, "protocol-version").orElse("");
        String protocolVersion = rawProtocolVersion;
        if (protocolVersion.isEmpty()) {
            return protocolVersion;
        }
        protocolVersion = this.normalizeProtocolVersion(protocolVersion);
        try {
            return HttpClient.Version.valueOf(protocolVersion).toString();
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unsupported protocol version: " + protocolVersion);
            throw new ConfigException("Unsupported protocol version provided: " + rawProtocolVersion, new Object[]{e});
        }
    }

    private String normalizeProtocolVersion(String protocolVersion) {
        return protocolVersion.toUpperCase().replaceAll("/", "_").replaceAll("\\.", "_");
    }

    private boolean isServiceUp(HttpClient client) {
        URI serviceStatusUri = this.getServiceStatusUri();
        if (serviceStatusUri == null) {
            return true;
        }
        try {
            HttpResponse response = client.execute(new HttpRequest(HttpMethod.GET, serviceStatusUri.toString()));
            LOG.fine(Contents.string(response));
            return 200 == response.getStatus();
        }
        catch (Exception e) {
            throw new ConfigException("Unable to reach the service at " + String.valueOf(this.getServiceUri()), new Object[]{e});
        }
    }

    public Map<Capabilities, Collection<SessionFactory>> getSessionFactories(Tracer tracer, HttpClient.Factory clientFactory, Duration sessionTimeout) {
        List<String> allConfigs = this.config.getAll(RELAY_SECTION, "configs").orElseThrow(() -> new ConfigException("Unable to find configs for " + String.valueOf(this.getServiceUri()), new Object[0]));
        HashMultimap<Integer, Capabilities> parsedConfigs = HashMultimap.create();
        for (int i = 0; i < allConfigs.size(); ++i) {
            int maxSessions2;
            try {
                maxSessions2 = Integer.parseInt(this.extractConfiguredValue(allConfigs.get(i)));
            }
            catch (NumberFormatException e) {
                throw new ConfigException("Unable parse value as number. " + allConfigs.get(i), new Object[0]);
            }
            if (++i == allConfigs.size()) {
                throw new ConfigException("Unable to find stereotype config. " + String.valueOf(allConfigs), new Object[0]);
            }
            Capabilities stereotype2 = (Capabilities)JSON.toType(this.extractConfiguredValue(allConfigs.get(i)), (Type)((Object)Capabilities.class));
            parsedConfigs.put(maxSessions2, stereotype2);
        }
        ImmutableMultimap.Builder factories = ImmutableMultimap.builder();
        LOG.info(String.format("Adding relay configs for %s", this.getServiceUri()));
        parsedConfigs.forEach((maxSessions, stereotype) -> {
            ImmutableCapabilities immutable = new ImmutableCapabilities((Capabilities)stereotype);
            for (int i = 0; i < maxSessions; ++i) {
                factories.put(immutable, new RelaySessionFactory(tracer, clientFactory, sessionTimeout, this.getServiceUri(), this.getServiceStatusUri(), this.getServiceProtocolVersion(), immutable));
            }
            LOG.info(String.format("Mapping %s, %d times", immutable, maxSessions));
        });
        return factories.build().asMap();
    }

    private String extractConfiguredValue(String keyValue) {
        if (keyValue.contains("=")) {
            return keyValue.substring(keyValue.indexOf("=") + 1);
        }
        return keyValue;
    }
}

