/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.router.httpd;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.grid.TemplateGridServerCommand;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.MapConfig;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.grid.distributor.config.DistributorOptions;
import org.openqa.selenium.grid.distributor.remote.RemoteDistributor;
import org.openqa.selenium.grid.graphql.GraphqlHandler;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.router.ProxyWebsocketsIntoGrid;
import org.openqa.selenium.grid.router.Router;
import org.openqa.selenium.grid.router.httpd.RouterOptions;
import org.openqa.selenium.grid.security.BasicAuthenticationFilter;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.security.SecretOptions;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.grid.server.Server;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.sessionmap.config.SessionMapOptions;
import org.openqa.selenium.grid.sessionqueue.config.NewSessionQueueOptions;
import org.openqa.selenium.grid.sessionqueue.remote.RemoteNewSessionQueue;
import org.openqa.selenium.grid.web.GridUiRoute;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.net.Urls;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.Tracer;

@AutoService(value={CliCommand.class})
public class RouterServer
extends TemplateGridServerCommand {
    private static final Logger LOG = Logger.getLogger(RouterServer.class.getName());

    @Override
    public String getName() {
        return "router";
    }

    @Override
    public String getDescription() {
        return "Creates a router to front the selenium grid.";
    }

    @Override
    public Set<Role> getConfigurableRoles() {
        return ImmutableSet.of(StandardGridRoles.DISTRIBUTOR_ROLE, StandardGridRoles.HTTPD_ROLE, StandardGridRoles.ROUTER_ROLE, StandardGridRoles.SESSION_MAP_ROLE, StandardGridRoles.SESSION_QUEUE_ROLE);
    }

    @Override
    public Set<Object> getFlagObjects() {
        return Collections.emptySet();
    }

    @Override
    protected String getSystemPropertiesConfigPrefix() {
        return "router";
    }

    @Override
    protected Config getDefaultConfig() {
        return new MapConfig(ImmutableMap.of("server", ImmutableMap.of("port", 4444)));
    }

    @Override
    protected TemplateGridServerCommand.Handlers createHandlers(Config config) {
        Routable route;
        LoggingOptions loggingOptions = new LoggingOptions(config);
        Tracer tracer = loggingOptions.getTracer();
        NetworkOptions networkOptions = new NetworkOptions(config);
        HttpClient.Factory clientFactory = networkOptions.getHttpClientFactory(tracer);
        BaseServerOptions serverOptions = new BaseServerOptions(config);
        SecretOptions secretOptions = new SecretOptions(config);
        Secret secret = secretOptions.getRegistrationSecret();
        SessionMapOptions sessionsOptions = new SessionMapOptions(config);
        SessionMap sessions = sessionsOptions.getSessionMap();
        NewSessionQueueOptions newSessionQueueOptions = new NewSessionQueueOptions(config);
        URL sessionQueueUrl = Urls.fromUri(newSessionQueueOptions.getSessionQueueUri());
        Duration sessionRequestTimeout = newSessionQueueOptions.getSessionRequestTimeout();
        ClientConfig httpClientConfig = ClientConfig.defaultConfig().baseUrl(sessionQueueUrl).readTimeout(sessionRequestTimeout);
        RemoteNewSessionQueue queue = new RemoteNewSessionQueue(tracer, clientFactory.createClient(httpClientConfig), secret);
        DistributorOptions distributorOptions = new DistributorOptions(config);
        URL distributorUrl = Urls.fromUri(distributorOptions.getDistributorUri());
        RemoteDistributor distributor = new RemoteDistributor(tracer, clientFactory, distributorUrl, secret);
        GraphqlHandler graphqlHandler = new GraphqlHandler(tracer, distributor, queue, serverOptions.getExternalUri(), this.getServerVersion());
        RouterOptions routerOptions = new RouterOptions(config);
        String subPath = routerOptions.subPath();
        Router router = new Router(tracer, clientFactory, sessions, queue, distributor);
        Routable routerWithSpecChecks = router.with(networkOptions.getSpecComplianceChecks());
        Routable appendRoute = Stream.of(RouterServer.baseRoute(subPath, Route.combine(routerWithSpecChecks, new Routable[0])), RouterServer.hubRoute(subPath, Route.combine(routerWithSpecChecks, new Routable[0])), RouterServer.graphqlRoute(subPath, () -> graphqlHandler)).reduce((x$0, xva$1) -> Route.combine(x$0, xva$1)).get();
        if (routerOptions.disableUi()) {
            LOG.info("Grid UI has been disabled.");
            route = appendRoute;
        } else {
            GridUiRoute ui = new GridUiRoute(subPath);
            route = Route.combine(ui, appendRoute);
        }
        UsernameAndPassword uap = secretOptions.getServerAuthentication();
        if (uap != null) {
            LOG.info("Requiring authentication to connect");
            route = route.with(new BasicAuthenticationFilter(uap.username(), uap.password()));
        }
        HttpHandler readinessCheck = req -> {
            boolean ready = router.isReady();
            return (HttpResponse)new HttpResponse().setStatus(ready ? 200 : 503).setContent(Contents.utf8String("Router is " + ready));
        };
        Route routeWithLiveness = Route.combine(route, Route.get("/readyz").to(() -> readinessCheck));
        return new TemplateGridServerCommand.Handlers(routeWithLiveness, new ProxyWebsocketsIntoGrid(clientFactory, sessions));
    }

    @Override
    protected void execute(Config config) {
        Require.nonNull("Config", config);
        config.get("server", "max-threads").ifPresent(value -> LOG.log(Level.WARNING, () -> "Support for max-threads flag is deprecated. The intent of the flag is to set the thread pool size in the Distributor. Please use newsession-threadpool-size flag instead."));
        Server server = (Server)this.asServer(config).start();
        LOG.info(String.format("Started Selenium Router %s: %s", this.getServerVersion(), server.getUrl()));
    }

    private String getServerVersion() {
        BuildInfo info = new BuildInfo();
        return String.format("%s (revision %s)", info.getReleaseLabel(), info.getBuildRevision());
    }
}

