/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.netty.server;

import com.google.common.io.ByteSource;
import com.google.common.io.FileBackedOutputStream;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.openqa.selenium.internal.Debug;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.AttributeKey;

class RequestConverter
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Logger LOG = Logger.getLogger(RequestConverter.class.getName());
    private static final List<HttpMethod> SUPPORTED_METHODS = Arrays.asList(HttpMethod.DELETE, HttpMethod.GET, HttpMethod.POST, HttpMethod.OPTIONS);
    private volatile FileBackedOutputStream buffer;
    private volatile int length;
    private volatile org.openqa.selenium.remote.http.HttpRequest request;

    RequestConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        LOG.log(Debug.getDebugLogLevel(), "Incoming message: {0}", msg);
        if (msg instanceof HttpRequest) {
            LOG.log(Debug.getDebugLogLevel(), "Start of http request: {0}", msg);
            HttpRequest nettyRequest = (HttpRequest)msg;
            if (nettyRequest.headers().contains("Sec-WebSocket-Version") && "upgrade".equalsIgnoreCase(nettyRequest.headers().get("Connection"))) {
                ReferenceCountUtil.retain(msg);
                ctx.fireChannelRead(msg);
                return;
            }
            this.request = this.createRequest(ctx, nettyRequest);
            if (this.request == null) {
                return;
            }
            if (HttpUtil.is100ContinueExpected(nettyRequest)) {
                ctx.write(new HttpResponse().setStatus(100));
                return;
            }
            this.request.setAttribute(AttributeKey.HTTP_SCHEME.getKey(), nettyRequest.protocolVersion().protocolName());
            this.request.setAttribute(AttributeKey.HTTP_FLAVOR.getKey(), nettyRequest.protocolVersion().majorVersion());
            this.buffer = null;
            this.length = -1;
        }
        if (msg instanceof HttpContent) {
            ByteBuf buf = ((HttpContent)msg).content().retain();
            int nBytes = buf.readableBytes();
            if (nBytes > 0) {
                if (this.buffer == null) {
                    this.buffer = new FileBackedOutputStream(0x300000, true);
                    this.length = 0;
                }
                try {
                    buf.readBytes(this.buffer, nBytes);
                    this.length += nBytes;
                }
                finally {
                    buf.release();
                }
            }
            if (msg instanceof LastHttpContent) {
                LOG.log(Debug.getDebugLogLevel(), "End of http request: {0}", msg);
                if (this.buffer != null) {
                    final ByteSource source = this.buffer.asByteSource();
                    final int len = this.length;
                    this.request.setContent(new Contents.Supplier(){

                        @Override
                        public InputStream get() {
                            try {
                                return source.openBufferedStream();
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        }

                        @Override
                        public int length() {
                            return len;
                        }

                        @Override
                        public void close() throws IOException {
                            RequestConverter.this.buffer.reset();
                        }
                    });
                } else {
                    this.request.setContent(Contents.empty());
                }
                ctx.fireChannelRead(this.request);
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        LOG.log(Debug.getDebugLogLevel(), "Channel became inactive.");
        super.channelInactive(ctx);
    }

    private org.openqa.selenium.remote.http.HttpRequest createRequest(ChannelHandlerContext ctx, HttpRequest nettyRequest) {
        org.openqa.selenium.remote.http.HttpMethod method;
        if (nettyRequest.method().equals(HttpMethod.HEAD)) {
            method = org.openqa.selenium.remote.http.HttpMethod.GET;
        } else if (SUPPORTED_METHODS.contains(nettyRequest.method())) {
            try {
                method = org.openqa.selenium.remote.http.HttpMethod.valueOf(nettyRequest.method().name());
            }
            catch (IllegalArgumentException e) {
                ctx.writeAndFlush(new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED));
                return null;
            }
        } else {
            ctx.writeAndFlush(new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED));
            return null;
        }
        try {
            QueryStringDecoder decoder = new QueryStringDecoder(nettyRequest.uri());
            org.openqa.selenium.remote.http.HttpRequest req = new org.openqa.selenium.remote.http.HttpRequest(method, decoder.path());
            decoder.parameters().forEach((key, values) -> values.forEach(value -> req.addQueryParameter((String)key, (String)value)));
            nettyRequest.headers().entries().stream().filter(entry -> entry.getKey() != null).forEach(entry -> req.addHeader((String)entry.getKey(), (String)entry.getValue()));
            return req;
        }
        catch (Exception ignore) {
            ctx.writeAndFlush(new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
            LOG.log(Debug.getDebugLogLevel(), "Not possible to decode parameters. {0}", nettyRequest.uri());
            return null;
        }
    }
}

