/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.function.BiConsumer;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.AttributeMap;
import org.openqa.selenium.remote.tracing.Span;

public class RemoteTags {
    private static final Json JSON = new Json();
    public static final BiConsumer<Span, Capabilities> CAPABILITIES = (span, caps) -> span.setAttribute(AttributeKey.SESSION_CAPABILITIES.getKey(), RemoteTags.convertCapsToJsonString(caps));
    public static final BiConsumer<Span, SessionId> SESSION_ID = (span, id) -> span.setAttribute(AttributeKey.SESSION_ID.getKey(), String.valueOf(id));
    public static final BiConsumer<AttributeMap, Capabilities> CAPABILITIES_EVENT = (map, caps) -> map.put(AttributeKey.SESSION_CAPABILITIES.getKey(), RemoteTags.convertCapsToJsonString(caps));
    public static final BiConsumer<AttributeMap, SessionId> SESSION_ID_EVENT = (map, id) -> map.put(AttributeKey.SESSION_ID.getKey(), String.valueOf(id));

    private RemoteTags() {
    }

    private static String convertCapsToJsonString(Capabilities capabilities) {
        StringBuilder text = new StringBuilder();
        try (JsonOutput json = JSON.newOutput(text).setPrettyPrint(false);){
            json.write(capabilities);
            text.append('\n');
        }
        return text.toString();
    }
}

